'
' A quicksort algorithm that uses stacks to avoid recursion.
' This one also uses the Median-of-three partitioning process to improve
' quicksort.
'
' Brad Merrill, May 22, 2001
'
Friend Class Stack
    Private stack() As Integer
    Private p As Integer

    Public Sub New(ByVal max As Integer)
        stack = New Integer(max) {}
        p = 0
    End Sub

    Public Sub New()
        MyClass.New(100)
    End Sub

    Public Sub Push(ByVal v As Integer)
        stack(p) = v
        p += 1
    End Sub 'Push

    Public Function Pop() As Integer
        p -= 1
        Return stack(p)
    End Function 'Pop

    Public ReadOnly Property IsEmpty() As Boolean
        Get
            Return p = 0
        End Get
    End Property
End Class 'Stack

Friend Class QSort
    Private stack As Stack = Nothing

    Function partition(ByVal a() As Integer, ByVal l As Integer, ByVal r As Integer) As Integer
        Dim i As Integer
        Dim j As Integer
        Dim v As Integer
        Dim t As Integer
        Dim m As Integer

        m = l + (r - l) \ 2 ' establish the midpoint
        ' the following is the 3-exchange method
        If a(l) > a(m) Then
            t = a(m)
            a(m) = a(l)
            a(l) = t
        End If
        If a(l) > a(r) Then
            t = a(l)
            a(l) = a(r)
            a(r) = t
        End If
        If a(m) > a(r) Then
            t = a(m)
            a(m) = a(r)
            a(r) = t
        End If

        ' then exchange the one in the middle with r-1
        t = a(m)
        a(m) = a((r - 1))
        a((r - 1)) = t

        v = a((r - 1)) ' this was our median element

        ' now run the partitioning on l+1 thru r-2
        r = r - 1 ' the test is i<r so just decr r by 1
        l = l + 1

        i = l - 1
        j = r


        While True
            While i < r
                i += 1
                If a(i) > v Then
                    Exit While
                End If
            End While
            While j > l
                j -= 1
                If a(j) < v Then
                    Exit While
                End If
            End While
            If i >= j Then
                Exit While
            End If
            t = a(i)
            a(i) = a(j)
            a(j) = t
        End While
        t = a(i)
        a(i) = a(r)
        a(r) = t
        Return i
    End Function 'partition

    Private Sub sort(ByVal a() As Integer, ByVal l As Integer, ByVal r As Integer)
        Dim i As Integer

        While True
            While r > l
                i = partition(a, l, r)
                If i - l > r - i Then
                    stack.Push(l)
                    stack.Push((i - 1))
                    l = i + 1
                Else
                    stack.Push((i + 1))
                    stack.Push(r)
                    r = i - 1
                End If
            End While
            If stack.IsEmpty Then
                Exit While
            End If
            r = stack.Pop()
            l = stack.Pop()
        End While
    End Sub 'sort

    Private Sub New() ' non-public constructor
    End Sub

    Public Shared Sub Sort(ByVal a() As Integer)
        Dim q As New QSort()
        q.stack = New Stack(a.Length)
        q.sort(a, 0, a.Length - 1)
    End Sub

End Class 'QSort